/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.implcore.metrics;

import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.common.Clock;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.common.ToLongFunction;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.implcore.internal.Utils;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.implcore.metrics.Meter;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.DerivedLongGauge;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.LabelKey;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.LabelValue;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.Metric;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.MetricDescriptor;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.Point;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.TimeSeries;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.Value;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class DerivedLongGaugeImpl
extends DerivedLongGauge
implements Meter {
    private final MetricDescriptor metricDescriptor;
    private final int labelKeysSize;
    private final List<LabelValue> constantLabelValues;
    private volatile Map<List<LabelValue>, PointWithFunction<?>> registeredPoints = Collections.emptyMap();

    DerivedLongGaugeImpl(String name, String description, String unit, List<LabelKey> labelKeys, Map<LabelKey, LabelValue> constantLabels) {
        ArrayList<LabelValue> constantLabelValues = new ArrayList<LabelValue>();
        ArrayList<LabelKey> allKeys = new ArrayList<LabelKey>(labelKeys);
        for (Map.Entry<LabelKey, LabelValue> label : constantLabels.entrySet()) {
            allKeys.add(label.getKey());
            constantLabelValues.add(label.getValue());
        }
        this.labelKeysSize = allKeys.size();
        this.metricDescriptor = MetricDescriptor.create(name, description, unit, MetricDescriptor.Type.GAUGE_INT64, allKeys);
        this.constantLabelValues = Collections.unmodifiableList(constantLabelValues);
    }

    @Override
    public synchronized <T> void createTimeSeries(List<LabelValue> labelValues, @Nullable T obj, ToLongFunction<T> function) {
        Preconditions.checkNotNull(function, "function");
        Utils.checkListElementNotNull(Preconditions.checkNotNull(labelValues, "labelValues"), "labelValue");
        ArrayList<LabelValue> labelValuesCopy = new ArrayList<LabelValue>(labelValues);
        labelValuesCopy.addAll(this.constantLabelValues);
        Preconditions.checkArgument(this.labelKeysSize == labelValuesCopy.size(), "Label Keys and Label Values don't have same size.");
        PointWithFunction<?> existingPoint = this.registeredPoints.get(Collections.unmodifiableList(labelValuesCopy));
        if (existingPoint != null) {
            throw new IllegalArgumentException("A different time series with the same labels already exists.");
        }
        PointWithFunction<T> newPoint = new PointWithFunction<T>(labelValuesCopy, obj, function);
        LinkedHashMap registeredPointsCopy = new LinkedHashMap(this.registeredPoints);
        registeredPointsCopy.put(labelValuesCopy, newPoint);
        this.registeredPoints = Collections.unmodifiableMap(registeredPointsCopy);
    }

    @Override
    public synchronized void removeTimeSeries(List<LabelValue> labelValues) {
        ArrayList<LabelValue> labelValuesCopy = new ArrayList<LabelValue>((Collection)Preconditions.checkNotNull(labelValues, "labelValues"));
        labelValuesCopy.addAll(this.constantLabelValues);
        LinkedHashMap registeredPointsCopy = new LinkedHashMap(this.registeredPoints);
        if (registeredPointsCopy.remove(labelValuesCopy) == null) {
            return;
        }
        this.registeredPoints = Collections.unmodifiableMap(registeredPointsCopy);
    }

    @Override
    public synchronized void clear() {
        this.registeredPoints = Collections.emptyMap();
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }

    @Override
    @Nullable
    public Metric getMetric(Clock clock) {
        Map<List<LabelValue>, PointWithFunction<?>> currentRegisteredPoints = this.registeredPoints;
        if (currentRegisteredPoints.isEmpty()) {
            return null;
        }
        if (currentRegisteredPoints.size() == 1) {
            PointWithFunction<?> point = currentRegisteredPoints.values().iterator().next();
            return Metric.createWithOneTimeSeries(this.metricDescriptor, ((PointWithFunction)point).getTimeSeries(clock));
        }
        ArrayList<TimeSeries> timeSeriesList = new ArrayList<TimeSeries>(currentRegisteredPoints.size());
        for (Map.Entry<List<LabelValue>, PointWithFunction<?>> entry : currentRegisteredPoints.entrySet()) {
            timeSeriesList.add(((PointWithFunction)entry.getValue()).getTimeSeries(clock));
        }
        return Metric.create(this.metricDescriptor, timeSeriesList);
    }

    public static final class PointWithFunction<T> {
        private final TimeSeries defaultTimeSeries;
        @Nullable
        private final WeakReference<T> ref;
        private final ToLongFunction<T> function;

        PointWithFunction(List<LabelValue> labelValues, @Nullable T obj, ToLongFunction<T> function) {
            this.defaultTimeSeries = TimeSeries.create(labelValues);
            this.ref = obj != null ? new WeakReference<T>(obj) : null;
            this.function = function;
        }

        private TimeSeries getTimeSeries(Clock clock) {
            Object obj = this.ref != null ? (Object)this.ref.get() : null;
            long value = this.function.applyAsLong(obj);
            return this.defaultTimeSeries.setPoint(Point.create(Value.longValue(value), clock.now()));
        }
    }
}

