/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.mutaterows;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.batching.BatchEntry;
import com.google.bigtable.repackaged.com.google.api.gax.batching.BatchingDescriptor;
import com.google.bigtable.repackaged.com.google.api.gax.batching.BatchingRequestBuilder;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiException;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.MutateRowsException;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.bigtable.repackaged.com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;

@InternalApi(value="For internal use only")
public class MutateRowsBatchingDescriptor
implements BatchingDescriptor<RowMutationEntry, Void, BulkMutation, Void> {
    @Override
    public BatchingRequestBuilder<RowMutationEntry, BulkMutation> newRequestBuilder(BulkMutation prototype) {
        return new RequestBuilder(prototype);
    }

    @Override
    public void splitResponse(Void response, List<BatchEntry<RowMutationEntry, Void>> entries) {
        for (BatchEntry<RowMutationEntry, Void> batchResponse : entries) {
            batchResponse.getResultFuture().set(null);
        }
    }

    @Override
    public void splitException(Throwable throwable, List<BatchEntry<RowMutationEntry, Void>> entries) {
        if (!(throwable instanceof MutateRowsException)) {
            for (BatchEntry<RowMutationEntry, Void> entry : entries) {
                entry.getResultFuture().setException(throwable);
            }
            return;
        }
        List<MutateRowsException.FailedMutation> failedMutations = ((MutateRowsException)throwable).getFailedMutations();
        HashMap<Integer, ApiException> entryErrors = Maps.newHashMap();
        for (MutateRowsException.FailedMutation failure : failedMutations) {
            entryErrors.put(failure.getIndex(), failure.getError());
        }
        int i = 0;
        for (BatchEntry<RowMutationEntry, Void> entry : entries) {
            Throwable entryError;
            if ((entryError = (Throwable)entryErrors.get(i++)) == null) {
                entry.getResultFuture().set(null);
                continue;
            }
            entry.getResultFuture().setException(entryError);
        }
    }

    @Override
    public long countBytes(RowMutationEntry entry) {
        return entry.toProto().getSerializedSize();
    }

    static class RequestBuilder
    implements BatchingRequestBuilder<RowMutationEntry, BulkMutation> {
        private BulkMutation bulkMutation;

        RequestBuilder(BulkMutation prototype) {
            this.bulkMutation = prototype.clone();
        }

        @Override
        public void add(RowMutationEntry entry) {
            this.bulkMutation.add(entry);
        }

        @Override
        public BulkMutation build() {
            return this.bulkMutation;
        }
    }
}

