/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index.sorted;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTuplePrefix;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.index.IndexRow;
import org.apache.ignite.internal.storage.index.IndexRowImpl;
import org.apache.ignite.internal.storage.index.SortedIndexDescriptor;
import org.apache.ignite.internal.storage.index.SortedIndexStorage;
import org.apache.ignite.internal.storage.pagememory.index.freelist.IndexColumns;
import org.apache.ignite.internal.storage.pagememory.index.freelist.IndexColumnsFreeList;
import org.apache.ignite.internal.storage.pagememory.index.sorted.InsertSortedIndexRowInvokeClosure;
import org.apache.ignite.internal.storage.pagememory.index.sorted.RemoveSortedIndexRowInvokeClosure;
import org.apache.ignite.internal.storage.pagememory.index.sorted.SortedIndexRow;
import org.apache.ignite.internal.storage.pagememory.index.sorted.SortedIndexRowKey;
import org.apache.ignite.internal.storage.pagememory.index.sorted.SortedIndexTree;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.CursorUtils;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

public class PageMemorySortedIndexStorage
implements SortedIndexStorage {
    private final SortedIndexDescriptor descriptor;
    private final IndexColumnsFreeList freeList;
    private final SortedIndexTree sortedIndexTree;
    private final int partitionId;
    private final RowId lowestRowId;
    private final RowId highestRowId;

    public PageMemorySortedIndexStorage(SortedIndexDescriptor descriptor, IndexColumnsFreeList freeList, SortedIndexTree sortedIndexTree) {
        this.descriptor = descriptor;
        this.freeList = freeList;
        this.sortedIndexTree = sortedIndexTree;
        this.partitionId = sortedIndexTree.partitionId();
        this.lowestRowId = new RowId(this.partitionId, Long.MIN_VALUE, Long.MIN_VALUE);
        this.highestRowId = new RowId(this.partitionId, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    public SortedIndexDescriptor indexDescriptor() {
        return this.descriptor;
    }

    public Cursor<RowId> get(BinaryTuple key) throws StorageException {
        SortedIndexRow lowerBound = this.toSortedIndexRow(key, this.lowestRowId);
        SortedIndexRow upperBound = this.toSortedIndexRow(key, this.highestRowId);
        try {
            return CursorUtils.map((Cursor)this.sortedIndexTree.find(lowerBound, upperBound), SortedIndexRow::rowId);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Failed to create scan cursor", (Throwable)e);
        }
    }

    public void put(IndexRow row) {
        try {
            SortedIndexRow sortedIndexRow = this.toSortedIndexRow(row.indexColumns(), row.rowId());
            InsertSortedIndexRowInvokeClosure insert = new InsertSortedIndexRowInvokeClosure(sortedIndexRow, this.freeList, this.sortedIndexTree.inlineSize());
            this.sortedIndexTree.invoke(sortedIndexRow, null, insert);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Failed to put value into index", (Throwable)e);
        }
    }

    public void remove(IndexRow row) {
        try {
            SortedIndexRow sortedIndexRow = this.toSortedIndexRow(row.indexColumns(), row.rowId());
            RemoveSortedIndexRowInvokeClosure remove = new RemoveSortedIndexRowInvokeClosure(sortedIndexRow, this.freeList);
            this.sortedIndexTree.invoke(sortedIndexRow, null, remove);
            remove.afterCompletion();
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Failed to remove value from index", (Throwable)e);
        }
    }

    public Cursor<IndexRow> scan(@Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags) {
        boolean includeLower = (flags & 1) != 0;
        boolean includeUpper = (flags & 2) != 0;
        SortedIndexRowKey lower = this.createBound(lowerBound, !includeLower);
        SortedIndexRowKey upper = this.createBound(upperBound, includeUpper);
        try {
            return CursorUtils.map((Cursor)this.sortedIndexTree.find(lower, upper), this::toIndexRowImpl);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Failed to create scan cursor", (Throwable)e);
        }
    }

    @Nullable
    private SortedIndexRowKey createBound(@Nullable BinaryTuplePrefix bound, boolean setEqualityFlag) {
        if (bound == null) {
            return null;
        }
        ByteBuffer buffer = bound.byteBuffer();
        if (setEqualityFlag) {
            byte flags = buffer.get(0);
            buffer.put(0, (byte)(flags | 0x10));
        }
        return new SortedIndexRowKey(new IndexColumns(this.partitionId, buffer));
    }

    private SortedIndexRow toSortedIndexRow(BinaryTuple tuple, RowId rowId) {
        return new SortedIndexRow(new IndexColumns(this.partitionId, tuple.byteBuffer()), rowId);
    }

    private IndexRowImpl toIndexRowImpl(SortedIndexRow sortedIndexRow) {
        return new IndexRowImpl(new BinaryTuple(this.descriptor.binaryTupleSchema(), sortedIndexRow.indexColumns().valueBuffer()), sortedIndexRow.rowId());
    }
}

