/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.UUID;
import org.apache.ignite.internal.pagememory.persistence.io.PartitionMetaIo;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PartitionMeta {
    private static final VarHandle PAGE_COUNT;
    private static final VarHandle META_SNAPSHOT;
    private volatile long lastAppliedIndex;
    private volatile long rowVersionFreeListRootPageId;
    private volatile long indexColumnsFreeListRootPageId;
    private volatile long versionChainTreeRootPageId;
    private volatile long indexTreeMetaPageId;
    private volatile int pageCount;
    private volatile PartitionMetaSnapshot metaSnapshot;

    @TestOnly
    public PartitionMeta() {
        this.metaSnapshot = new PartitionMetaSnapshot(null, this);
    }

    public PartitionMeta(@Nullable UUID checkpointId, long lastAppliedIndex, long rowVersionFreeListRootPageId, long indexColumnsFreeListRootPageId, long versionChainTreeRootPageId, long indexTreeMetaPageId, int pageCount) {
        this.lastAppliedIndex = lastAppliedIndex;
        this.rowVersionFreeListRootPageId = rowVersionFreeListRootPageId;
        this.indexColumnsFreeListRootPageId = indexColumnsFreeListRootPageId;
        this.versionChainTreeRootPageId = versionChainTreeRootPageId;
        this.indexTreeMetaPageId = indexTreeMetaPageId;
        this.pageCount = pageCount;
        this.metaSnapshot = new PartitionMetaSnapshot(checkpointId, this);
    }

    PartitionMeta(@Nullable UUID checkpointId, PartitionMetaIo metaIo, long pageAddr) {
        this(checkpointId, metaIo.getLastAppliedIndex(pageAddr), metaIo.getRowVersionFreeListRootPageId(pageAddr), metaIo.getIndexColumnsFreeListRootPageId(pageAddr), metaIo.getVersionChainTreeRootPageId(pageAddr), metaIo.getIndexTreeMetaPageId(pageAddr), metaIo.getPageCount(pageAddr));
    }

    public long lastAppliedIndex() {
        return this.lastAppliedIndex;
    }

    public void lastAppliedIndex(@Nullable UUID checkpointId, long lastAppliedIndex) {
        this.updateSnapshot(checkpointId);
        this.lastAppliedIndex = lastAppliedIndex;
    }

    public long versionChainTreeRootPageId() {
        return this.versionChainTreeRootPageId;
    }

    public void versionChainTreeRootPageId(@Nullable UUID checkpointId, long versionChainTreeRootPageId) {
        this.updateSnapshot(checkpointId);
        this.versionChainTreeRootPageId = versionChainTreeRootPageId;
    }

    public long rowVersionFreeListRootPageId() {
        return this.rowVersionFreeListRootPageId;
    }

    public void rowVersionFreeListRootPageId(@Nullable UUID checkpointId, long rowVersionFreeListRootPageId) {
        this.updateSnapshot(checkpointId);
        this.rowVersionFreeListRootPageId = rowVersionFreeListRootPageId;
    }

    public long indexColumnsFreeListRootPageId() {
        return this.indexColumnsFreeListRootPageId;
    }

    public void indexColumnsFreeListRootPageId(@Nullable UUID checkpointId, long indexColumnsFreeListRootPageId) {
        this.updateSnapshot(checkpointId);
        this.indexColumnsFreeListRootPageId = indexColumnsFreeListRootPageId;
    }

    public long indexTreeMetaPageId() {
        return this.indexTreeMetaPageId;
    }

    public void indexTreeMetaPageId(@Nullable UUID checkpointId, long indexTreeMetaPageId) {
        this.updateSnapshot(checkpointId);
        this.indexTreeMetaPageId = indexTreeMetaPageId;
    }

    public int pageCount() {
        return this.pageCount;
    }

    public void incrementPageCount(@Nullable UUID checkpointId) {
        this.updateSnapshot(checkpointId);
        PAGE_COUNT.getAndAdd(this, 1);
    }

    public PartitionMetaSnapshot metaSnapshot(@Nullable UUID checkpointId) {
        this.updateSnapshot(checkpointId);
        return this.metaSnapshot;
    }

    private void updateSnapshot(@Nullable UUID checkpointId) {
        PartitionMetaSnapshot current = this.metaSnapshot;
        if (current.checkpointId != checkpointId) {
            META_SNAPSHOT.compareAndSet(this, current, new PartitionMetaSnapshot(checkpointId, this));
        }
    }

    public String toString() {
        return S.toString(PartitionMeta.class, (Object)this);
    }

    public static long partitionMetaPageId(int partId) {
        return PageIdUtils.pageId(partId, (byte)2, 0);
    }

    static {
        try {
            PAGE_COUNT = MethodHandles.lookup().findVarHandle(PartitionMeta.class, "pageCount", Integer.TYPE);
            META_SNAPSHOT = MethodHandles.lookup().findVarHandle(PartitionMeta.class, "metaSnapshot", PartitionMetaSnapshot.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static class PartitionMetaSnapshot {
        @Nullable
        private final UUID checkpointId;
        private final long lastAppliedIndex;
        private final long versionChainTreeRootPageId;
        private final long rowVersionFreeListRootPageId;
        private final long indexColumnsFreeListRootPageId;
        private final long indexTreeMetaPageId;
        private final int pageCount;

        private PartitionMetaSnapshot(@Nullable UUID checkpointId, PartitionMeta partitionMeta) {
            this.checkpointId = checkpointId;
            this.lastAppliedIndex = partitionMeta.lastAppliedIndex;
            this.versionChainTreeRootPageId = partitionMeta.versionChainTreeRootPageId;
            this.rowVersionFreeListRootPageId = partitionMeta.rowVersionFreeListRootPageId;
            this.indexColumnsFreeListRootPageId = partitionMeta.indexColumnsFreeListRootPageId;
            this.indexTreeMetaPageId = partitionMeta.indexTreeMetaPageId;
            this.pageCount = partitionMeta.pageCount;
        }

        public long lastAppliedIndex() {
            return this.lastAppliedIndex;
        }

        public long versionChainTreeRootPageId() {
            return this.versionChainTreeRootPageId;
        }

        public long rowVersionFreeListRootPageId() {
            return this.rowVersionFreeListRootPageId;
        }

        public long indexColumnsFreeListRootPageId() {
            return this.indexColumnsFreeListRootPageId;
        }

        public long indexTreeMetaPageId() {
            return this.indexTreeMetaPageId;
        }

        public int pageCount() {
            return this.pageCount;
        }

        void writeTo(PartitionMetaIo metaIo, long pageAddr) {
            metaIo.setLastAppliedIndex(pageAddr, this.lastAppliedIndex);
            metaIo.setVersionChainTreeRootPageId(pageAddr, this.versionChainTreeRootPageId);
            metaIo.setIndexColumnsFreeListRootPageId(pageAddr, this.indexColumnsFreeListRootPageId);
            metaIo.setRowVersionFreeListRootPageId(pageAddr, this.rowVersionFreeListRootPageId);
            metaIo.setPageCount(pageAddr, this.pageCount);
            metaIo.setIndexTreeMetaPageId(pageAddr, this.indexTreeMetaPageId);
        }

        public String toString() {
            return S.toString(PartitionMetaSnapshot.class, (Object)this);
        }
    }
}

