/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.utils;

import java.util.Map;
import org.apache.iceberg.util.PropertyUtil;

public class CompatibleHivePropertyUtil {
    private CompatibleHivePropertyUtil() {
    }

    public static boolean propertyAsBoolean(Map<String, String> properties, String property, boolean defaultValue) {
        return PropertyUtil.propertyAsBoolean(properties, (String)CompatibleHivePropertyUtil.getCompatibleProperty(properties, property), (boolean)defaultValue);
    }

    public static double propertyAsDouble(Map<String, String> properties, String property, double defaultValue) {
        return PropertyUtil.propertyAsDouble(properties, (String)CompatibleHivePropertyUtil.getCompatibleProperty(properties, property), (double)defaultValue);
    }

    public static int propertyAsInt(Map<String, String> properties, String property, int defaultValue) {
        return PropertyUtil.propertyAsInt(properties, (String)CompatibleHivePropertyUtil.getCompatibleProperty(properties, property), (int)defaultValue);
    }

    public static long propertyAsLong(Map<String, String> properties, String property, long defaultValue) {
        return PropertyUtil.propertyAsLong(properties, (String)CompatibleHivePropertyUtil.getCompatibleProperty(properties, property), (long)defaultValue);
    }

    public static String propertyAsString(Map<String, String> properties, String property, String defaultValue) {
        return PropertyUtil.propertyAsString(properties, (String)CompatibleHivePropertyUtil.getCompatibleProperty(properties, property), (String)defaultValue);
    }

    private static String getCompatibleProperty(Map<String, String> properties, String property) {
        String legacyProperty = CompatibleHivePropertyUtil.getLegacyProperty(property);
        if (legacyProperty != null && properties.containsKey(legacyProperty) && !properties.containsKey(property)) {
            return legacyProperty;
        }
        return property;
    }

    private static String getLegacyProperty(String property) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "arctic.enabled": {
                return "arctic.enable";
            }
        }
        return null;
    }
}

