/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.optimizing;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.amoro.api.CommitMetaProducer;
import org.apache.amoro.data.DataFileType;
import org.apache.amoro.data.PrimaryKeyedFile;
import org.apache.amoro.hive.utils.TableTypeUtil;
import org.apache.amoro.op.OverwriteBaseFiles;
import org.apache.amoro.optimizing.RewriteFilesInput;
import org.apache.amoro.optimizing.RewriteFilesOutput;
import org.apache.amoro.server.exception.OptimizingCommitException;
import org.apache.amoro.server.optimizing.TaskRuntime;
import org.apache.amoro.server.optimizing.UnKeyedTableCommit;
import org.apache.amoro.table.KeyedTable;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.utils.ContentFiles;
import org.apache.amoro.utils.MixedTableUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.util.StructLikeMap;
import org.glassfish.jersey.internal.guava.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyedTableCommit
extends UnKeyedTableCommit {
    private static final Logger LOG = LoggerFactory.getLogger(KeyedTableCommit.class);
    protected MixedTable table;
    protected Collection<TaskRuntime> tasks;
    protected Long fromSnapshotId;
    protected StructLikeMap<Long> fromSequenceOfPartitions;
    protected StructLikeMap<Long> toSequenceOfPartitions;

    public KeyedTableCommit(MixedTable table, Collection<TaskRuntime> tasks, Long fromSnapshotId, StructLikeMap<Long> fromSequenceOfPartitions, StructLikeMap<Long> toSequenceOfPartitions) {
        super(fromSnapshotId, table, tasks);
        this.table = table;
        this.tasks = tasks;
        this.fromSnapshotId = fromSnapshotId == null ? -1L : fromSnapshotId;
        this.fromSequenceOfPartitions = fromSequenceOfPartitions;
        this.toSequenceOfPartitions = toSequenceOfPartitions;
    }

    @Override
    public void commit() throws OptimizingCommitException {
        if (this.tasks.isEmpty()) {
            LOG.info("{} found no tasks to commit", (Object)this.table.id());
        }
        LOG.info("{} found tasks to commit from snapshot {}", (Object)this.table.id(), (Object)this.fromSnapshotId);
        List<DataFile> hiveNewDataFiles = this.moveFile2HiveIfNeed();
        HashSet addedDataFiles = Sets.newHashSet();
        HashSet removedDataFiles = Sets.newHashSet();
        HashSet addedDeleteFiles = Sets.newHashSet();
        HashSet removedDeleteFiles = Sets.newHashSet();
        StructLikeMap partitionOptimizedSequence = MixedTableUtil.readOptimizedSequence((KeyedTable)this.table.asKeyedTable());
        for (TaskRuntime taskRuntime : this.tasks) {
            RewriteFilesInput input = taskRuntime.getInput();
            StructLike partition = this.partition(input);
            if (this.fileInPartitionNeedSkip(partition, (StructLikeMap<Long>)partitionOptimizedSequence, this.fromSequenceOfPartitions)) {
                this.toSequenceOfPartitions.remove((Object)partition);
                continue;
            }
            if (input.rewrittenDataFiles() != null) {
                Arrays.stream(input.rewrittenDataFiles()).map(s -> (PrimaryKeyedFile)s).filter(s -> s.type() == DataFileType.BASE_FILE).forEach(removedDataFiles::add);
            }
            if (input.rewrittenDeleteFiles() != null) {
                Arrays.stream(input.rewrittenDeleteFiles()).filter(ContentFiles::isDeleteFile).map(ContentFiles::asDeleteFile).forEach(removedDeleteFiles::add);
            }
            RewriteFilesOutput output = taskRuntime.getOutput();
            if (CollectionUtils.isNotEmpty(hiveNewDataFiles)) {
                addedDataFiles.addAll(hiveNewDataFiles);
            } else if (output.getDataFiles() != null) {
                Collections.addAll(addedDataFiles, output.getDataFiles());
            }
            if (output.getDeleteFiles() == null) continue;
            Collections.addAll(addedDeleteFiles, output.getDeleteFiles());
        }
        try {
            this.executeCommit(addedDataFiles, removedDataFiles, addedDeleteFiles, removedDeleteFiles);
        }
        catch (Exception e) {
            LOG.warn("Optimize commit table {} failed, give up commit.", (Object)this.table.id(), (Object)e);
            if (this.needMoveFile2Hive()) {
                this.correctHiveData(addedDataFiles, addedDeleteFiles);
            }
            throw new OptimizingCommitException("unexpected commit error ", e);
        }
    }

    private void executeCommit(Set<DataFile> addedDataFiles, Set<DataFile> removedDataFiles, Set<DeleteFile> addedDeleteFiles, Set<DeleteFile> removedDeleteFiles) {
        OverwriteBaseFiles overwriteBaseFiles = new OverwriteBaseFiles(this.table.asKeyedTable());
        overwriteBaseFiles.set("snapshot.producer", CommitMetaProducer.OPTIMIZE.name());
        overwriteBaseFiles.validateNoConflictingAppends((Expression)Expressions.alwaysFalse());
        overwriteBaseFiles.dynamic(false);
        this.toSequenceOfPartitions.forEach((arg_0, arg_1) -> ((OverwriteBaseFiles)overwriteBaseFiles).updateOptimizedSequence(arg_0, arg_1));
        addedDataFiles.forEach(arg_0 -> ((OverwriteBaseFiles)overwriteBaseFiles).addFile(arg_0));
        addedDeleteFiles.forEach(arg_0 -> ((OverwriteBaseFiles)overwriteBaseFiles).addFile(arg_0));
        removedDataFiles.forEach(arg_0 -> ((OverwriteBaseFiles)overwriteBaseFiles).deleteFile(arg_0));
        if (TableTypeUtil.isHive((MixedTable)this.table) && !this.needMoveFile2Hive()) {
            overwriteBaseFiles.set("delete-untracked-hive-file", "true");
            overwriteBaseFiles.set("sync-data-to-hive", "true");
        }
        overwriteBaseFiles.skipEmptyCommit().commit();
        if (CollectionUtils.isNotEmpty(removedDeleteFiles)) {
            RewriteFiles rewriteFiles = this.table.asKeyedTable().baseTable().newRewrite();
            rewriteFiles.set("snapshot.producer", CommitMetaProducer.OPTIMIZE.name());
            rewriteFiles.rewriteFiles(Collections.emptySet(), removedDeleteFiles, Collections.emptySet(), Collections.emptySet());
            try {
                rewriteFiles.commit();
            }
            catch (ValidationException e) {
                LOG.warn("Iceberg RewriteFiles commit failed, but ignore", (Throwable)e);
            }
        }
        LOG.info("{} optimize committed, delete {} files [{} posDelete files], add {} new files [{} posDelete files]", new Object[]{this.table.id(), removedDataFiles.size(), removedDeleteFiles.size(), addedDataFiles.size(), addedDataFiles.size()});
    }

    private boolean fileInPartitionNeedSkip(StructLike partitionData, StructLikeMap<Long> partitionOptimizedSequence, StructLikeMap<Long> fromSequenceOfPartitions) {
        Long optimizedSequence = (Long)partitionOptimizedSequence.getOrDefault((Object)partitionData, (Object)-1L);
        Long fromSequence = (Long)fromSequenceOfPartitions.getOrDefault((Object)partitionData, (Object)Long.MAX_VALUE);
        return optimizedSequence >= fromSequence;
    }

    private StructLike partition(RewriteFilesInput input) {
        return input.allFiles()[0].partition();
    }
}

