/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Iterables;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.GenericDataFile;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.False;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.ScanMetrics;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.util.ParallelIterable;
import org.apache.iceberg.util.PartitionSet;

public class IcebergFindFiles {
    private static final Types.StructType EMPTY_STRUCT = Types.StructType.of((Types.NestedField[])new Types.NestedField[0]);
    private final Table table;
    private final FileIO io;
    private final TableOperations ops;
    private Predicate<ManifestFile> manifestPredicate;
    private Predicate<ManifestEntry<?>> manifestEntryPredicate;
    private final Map<Integer, PartitionSpec> specsById;
    private Expression dataFilter;
    private Expression fileFilter;
    private Map<Integer, Expression> partitionFilters;
    private PartitionSet partitionSet;
    private boolean ignoreDeleted;
    private boolean ignoreExisting;
    private List<String> columns;
    private boolean caseSensitive;
    private ExecutorService executorService;
    private ScanMetrics scanMetrics;
    private Long snapshotId = null;
    private boolean includeColumnStats = false;
    private ManifestContent manifestContent;

    public IcebergFindFiles(Table table) {
        this.table = table;
        this.io = table.io();
        this.ops = ((HasTableOperations)table).operations();
        this.dataFilter = Expressions.alwaysTrue();
        this.fileFilter = Expressions.alwaysTrue();
        this.specsById = table.specs();
        this.ignoreDeleted = false;
        this.ignoreExisting = false;
        this.columns = ManifestReader.ALL_COLUMNS;
        this.caseSensitive = true;
        this.manifestPredicate = m -> true;
        this.manifestEntryPredicate = e -> true;
        this.scanMetrics = ScanMetrics.noop();
    }

    public IcebergFindFiles inSnapshot(long findSnapshotId) {
        Preconditions.checkArgument((this.snapshotId == null ? 1 : 0) != 0, (String)"Cannot set snapshot multiple times, already set to id=%s", (long)findSnapshotId);
        Preconditions.checkArgument((this.table.snapshot(findSnapshotId) != null ? 1 : 0) != 0, (String)"Cannot find snapshot for id=%s", (long)findSnapshotId);
        this.snapshotId = findSnapshotId;
        return this;
    }

    public IcebergFindFiles asOfTime(long timestampMillis) {
        HistoryEntry logEntry;
        Preconditions.checkArgument((this.snapshotId == null ? 1 : 0) != 0, (String)"Cannot set snapshot multiple times, already set to id=%s", (Object)this.snapshotId);
        Long lastSnapshotId = null;
        Iterator iterator = this.ops.current().snapshotLog().iterator();
        while (iterator.hasNext() && (logEntry = (HistoryEntry)iterator.next()).timestampMillis() <= timestampMillis) {
            lastSnapshotId = logEntry.snapshotId();
        }
        Preconditions.checkArgument((lastSnapshotId != null ? 1 : 0) != 0, (String)"Cannot find a snapshot older than %s", (Object)DateTimeUtil.formatTimestampMillis((long)timestampMillis));
        return this.inSnapshot(lastSnapshotId);
    }

    public IcebergFindFiles filterData(Expression newDataFilter) {
        this.dataFilter = Expressions.and((Expression)this.dataFilter, (Expression)newDataFilter);
        return this;
    }

    public IcebergFindFiles filterFiles(Expression newFileFilter) {
        this.fileFilter = Expressions.and((Expression)this.fileFilter, (Expression)newFileFilter);
        return this;
    }

    public IcebergFindFiles includeColumnStats() {
        this.includeColumnStats = true;
        return this;
    }

    public IcebergFindFiles fileContent(ManifestContent manifestContent) {
        this.manifestContent = manifestContent;
        return this;
    }

    public IcebergFindFiles inPartitions(PartitionSpec spec, StructLike ... partitions) {
        return this.inPartitions(spec, Arrays.asList(partitions));
    }

    public IcebergFindFiles inPartitions(PartitionSpec spec, List<StructLike> partitions) {
        if (this.partitionSet == null) {
            this.partitionSet = PartitionSet.create(this.specsById);
            this.partitionFilters = new HashMap<Integer, Expression>();
        }
        for (StructLike partition : partitions) {
            this.partitionSet.add(spec.specId(), partition);
        }
        False partitionSetFilter = Expressions.alwaysFalse();
        for (StructLike partitionData : partitions) {
            True partFilter = Expressions.alwaysTrue();
            for (int i = 0; i < spec.fields().size(); ++i) {
                PartitionField field = (PartitionField)spec.fields().get(i);
                Object partitionValue = partitionData.get(i, Object.class);
                partFilter = Objects.isNull(partitionValue) ? Expressions.and((Expression)partFilter, (Expression)Expressions.isNull((String)field.name())) : Expressions.and((Expression)partFilter, (Expression)Expressions.equal((String)field.name(), (Object)partitionValue));
            }
            partitionSetFilter = Expressions.or((Expression)partitionSetFilter, (Expression)partFilter);
        }
        this.partitionFilters.put(spec.specId(), (Expression)partitionSetFilter);
        return this;
    }

    public IcebergFindFiles filterManifests(Predicate<ManifestFile> newManifestPredicate) {
        this.manifestPredicate = this.manifestPredicate.and(newManifestPredicate);
        return this;
    }

    public IcebergFindFiles filterManifestEntries(Predicate<ManifestEntry<?>> newManifestEntryPredicate) {
        this.manifestEntryPredicate = this.manifestEntryPredicate.and(newManifestEntryPredicate);
        return this;
    }

    public IcebergFindFiles scanMetrics(ScanMetrics metrics) {
        this.scanMetrics = metrics;
        return this;
    }

    public IcebergFindFiles ignoreDeleted() {
        this.ignoreDeleted = true;
        return this;
    }

    public IcebergFindFiles ignoreExisting() {
        this.ignoreExisting = true;
        return this;
    }

    public IcebergFindFiles select(List<String> newColumns) {
        this.columns = Lists.newArrayList(newColumns);
        return this;
    }

    public IcebergFindFiles caseSensitive(boolean newCaseSensitive) {
        this.caseSensitive = newCaseSensitive;
        return this;
    }

    public IcebergFindFiles planWith(ExecutorService newExecutorService) {
        this.executorService = newExecutorService;
        return this;
    }

    public CloseableIterable<IcebergManifestEntry> entries() {
        BiFunction entryFn = (manifest, entries) -> CloseableIterable.transform((CloseableIterable)entries, e -> new IcebergManifestEntry((ContentFile)e.file().copy(this.includeColumnStats), IcebergManifestEntry.Status.parse(e.status().id()), e.snapshotId()));
        if (this.executorService != null) {
            return new ParallelIterable(this.entries(entryFn), this.executorService);
        }
        return CloseableIterable.concat(this.entries(entryFn));
    }

    private <T> Iterable<CloseableIterable<T>> entries(BiFunction<ManifestFile, CloseableIterable<ManifestEntry<?>>, CloseableIterable<T>> entryFn) {
        CloseableIterable matchingManifests;
        Snapshot snapshot;
        Snapshot snapshot2 = snapshot = this.snapshotId != null ? this.ops.current().snapshot(this.snapshotId.longValue()) : this.ops.current().currentSnapshot();
        if (snapshot == null) {
            return CloseableIterable.empty();
        }
        List manifests = this.manifestContent == null ? snapshot.allManifests(this.io) : (this.manifestContent == ManifestContent.DATA ? snapshot.dataManifests(this.io) : snapshot.deleteManifests(this.io));
        LoadingCache evalCache = this.specsById == null ? null : Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = this.specsById.get(specId);
            Expression partitionFilter = this.partitionFilter((Integer)specId);
            return ManifestEvaluator.forPartitionFilter((Expression)Expressions.and((Expression)partitionFilter, (Expression)Projections.inclusive((PartitionSpec)spec, (boolean)this.caseSensitive).project(this.dataFilter)), (PartitionSpec)spec, (boolean)this.caseSensitive);
        });
        Evaluator evaluator = this.fileFilter != null && this.fileFilter != Expressions.alwaysTrue() ? new Evaluator(DataFile.getType((Types.StructType)EMPTY_STRUCT), this.fileFilter, this.caseSensitive) : null;
        CloseableIterable closeableDataManifests = CloseableIterable.withNoopClose((Iterable)manifests);
        CloseableIterable closeableIterable = matchingManifests = evalCache == null ? closeableDataManifests : CloseableIterable.filter((Counter)this.scanMetrics.skippedDataManifests(), (CloseableIterable)closeableDataManifests, manifest -> ((ManifestEvaluator)evalCache.get((Object)manifest.partitionSpecId())).eval(manifest));
        if (this.ignoreDeleted) {
            matchingManifests = CloseableIterable.filter((Counter)this.scanMetrics.skippedDataManifests(), (CloseableIterable)matchingManifests, manifest -> manifest.hasAddedFiles() || manifest.hasExistingFiles());
        }
        if (this.ignoreExisting) {
            matchingManifests = CloseableIterable.filter((Counter)this.scanMetrics.skippedDataManifests(), (CloseableIterable)matchingManifests, manifest -> manifest.hasAddedFiles() || manifest.hasDeletedFiles());
        }
        matchingManifests = CloseableIterable.filter((Counter)this.scanMetrics.skippedDataManifests(), (CloseableIterable)matchingManifests, this.manifestPredicate);
        matchingManifests = CloseableIterable.count((Counter)this.scanMetrics.scannedDataManifests(), (CloseableIterable)matchingManifests);
        return Iterables.transform((Iterable)matchingManifests, manifest -> new CloseableIterable<T>(){
            private CloseableIterable<T> iterable;
            final /* synthetic */ ManifestFile val$manifest;
            final /* synthetic */ Evaluator val$evaluator;
            final /* synthetic */ BiFunction val$entryFn;
            {
                this.val$manifest = manifestFile;
                this.val$evaluator = evaluator;
                this.val$entryFn = biFunction;
            }

            public CloseableIterator<T> iterator() {
                ManifestReader reader = ManifestFiles.open((ManifestFile)this.val$manifest, (FileIO)IcebergFindFiles.this.io, (Map)IcebergFindFiles.this.specsById).filterRows(IcebergFindFiles.this.dataFilter).filterPartitions(IcebergFindFiles.this.partitionSet).caseSensitive(IcebergFindFiles.this.caseSensitive).select((Collection)IcebergFindFiles.this.columns).scanMetrics(IcebergFindFiles.this.scanMetrics);
                CloseableIterable tmpEntries = IcebergFindFiles.this.ignoreDeleted ? reader.liveEntries() : reader.entries();
                CloseableIterable entries = CloseableIterable.transform((CloseableIterable)tmpEntries, ManifestEntry.class::cast);
                if (IcebergFindFiles.this.ignoreExisting) {
                    entries = CloseableIterable.filter((Counter)IcebergFindFiles.this.scanMetrics.skippedDataFiles(), (CloseableIterable)entries, entry -> entry.status() != ManifestEntry.Status.EXISTING);
                }
                if (this.val$evaluator != null) {
                    entries = CloseableIterable.filter((Counter)IcebergFindFiles.this.scanMetrics.skippedDataFiles(), (CloseableIterable)entries, entry -> this.val$evaluator.eval((StructLike)((GenericDataFile)entry.file())));
                }
                this.iterable = (CloseableIterable)this.val$entryFn.apply(this.val$manifest, entries);
                return this.iterable.iterator();
            }

            public void close() throws IOException {
                if (this.iterable != null) {
                    this.iterable.close();
                }
            }
        });
    }

    private Expression partitionFilter(Integer specId) {
        if (this.partitionFilters == null || this.partitionFilters.isEmpty()) {
            return Expressions.alwaysTrue();
        }
        Expression filter = this.partitionFilters.get(specId);
        return filter == null ? Expressions.alwaysFalse() : filter;
    }

    public static class IcebergManifestEntry {
        private final ContentFile<?> file;
        private final Status status;
        private final long SnapshotId;

        public IcebergManifestEntry(ContentFile<?> file, Status status, long snapshotId) {
            this.file = file;
            this.status = status;
            this.SnapshotId = snapshotId;
        }

        public ContentFile<?> getFile() {
            return this.file;
        }

        public Status getStatus() {
            return this.status;
        }

        public long getSnapshotId() {
            return this.SnapshotId;
        }

        static enum Status {
            EXISTING(0),
            ADDED(1),
            DELETED(2);

            private final int id;

            private Status(int id) {
                this.id = id;
            }

            public int id() {
                return this.id;
            }

            public static Status parse(int id) {
                switch (id) {
                    case 0: {
                        return EXISTING;
                    }
                    case 1: {
                        return ADDED;
                    }
                    case 2: {
                        return DELETED;
                    }
                }
                throw new IllegalArgumentException("Unknown status id: " + id);
            }
        }
    }
}

