/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.optimizing;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.amoro.optimizing.RewriteFilesInput;
import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.amoro.table.descriptor.FilesStatistics;
import org.apache.amoro.table.descriptor.FilesStatisticsBuilder;
import org.apache.amoro.utils.CommonUtil;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileContent;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MetricsSummary {
    public static final String INPUT_DATA_FILES = "input-data-files(rewrite)";
    public static final String INPUT_DATA_SIZE = "input-data-size(rewrite)";
    public static final String INPUT_DATA_RECORDS = "input-data-records(rewrite)";
    public static final String INPUT_READ_ONLY_DATA_FILES = "input-data-files(read-only)";
    public static final String INPUT_READ_ONLY_DATA_SIZE = "input-data-size(read-only)";
    public static final String INPUT_READ_ONLY_DATA_RECORDS = "input-data-records(read-only)";
    public static final String INPUT_EQ_DELETE_FILES = "input-equality-delete-files";
    public static final String INPUT_EQ_DELETE_SIZE = "input-equality-delete-size";
    public static final String INPUT_EQ_DELETE_RECORDS = "input-equality-delete-records";
    public static final String INPUT_POS_DELETE_FILES = "input-position-delete-files";
    public static final String INPUT_POS_DELETE_SIZE = "input-position-delete-size";
    public static final String INPUT_POS_DELETE_RECORDS = "input-position-delete-records";
    public static final String OUTPUT_DATA_FILES = "output-data-files";
    public static final String OUTPUT_DATA_SIZE = "output-data-size";
    public static final String OUTPUT_DATA_RECORDS = "output-data-records";
    public static final String OUTPUT_DELETE_FILES = "output-delete-files";
    public static final String OUTPUT_DELETE_SIZE = "output-delete-size";
    public static final String OUTPUT_DELETE_RECORDS = "output-delete-records";
    private long rewriteDataSize = 0L;
    private int rewriteDataFileCnt = 0;
    private long rewriteDataRecordCnt = 0L;
    private long rewritePosDataSize = 0L;
    private int rewritePosDataFileCnt = 0;
    @Deprecated
    private int reRowDeletedDataFileCnt = 0;
    private long rewritePosDataRecordCnt = 0L;
    private long equalityDeleteSize = 0L;
    private int eqDeleteFileCnt = 0;
    private long eqDeleteRecordCnt = 0L;
    private long positionDeleteSize = 0L;
    @Deprecated
    private long positionalDeleteSize = 0L;
    private int posDeleteFileCnt = 0;
    private long posDeleteRecordCnt = 0L;
    @Deprecated
    private long newFileSize = 0L;
    @Deprecated
    private int newFileCnt = 0;
    private long newDataSize = 0L;
    private int newDataFileCnt = 0;
    private long newDataRecordCnt = 0L;
    private long newDeleteSize = 0L;
    private int newDeleteFileCnt = 0;
    private long newDeleteRecordCnt = 0L;

    public MetricsSummary() {
    }

    protected MetricsSummary(RewriteFilesInput input) {
        this.rewriteDataFileCnt = input.rewrittenDataFiles().length;
        this.rewritePosDataFileCnt = input.rePosDeletedDataFiles().length;
        this.reRowDeletedDataFileCnt = input.rePosDeletedDataFiles().length;
        for (DataFile dataFile : input.rewrittenDataFiles()) {
            this.rewriteDataSize += dataFile.fileSizeInBytes();
            this.rewriteDataRecordCnt += dataFile.recordCount();
        }
        for (DataFile dataFile : input.rePosDeletedDataFiles()) {
            this.rewritePosDataSize += dataFile.fileSizeInBytes();
            this.rewritePosDataRecordCnt += dataFile.recordCount();
        }
        for (DataFile dataFile : input.deleteFiles()) {
            if (dataFile.content() == FileContent.POSITION_DELETES) {
                this.positionDeleteSize += dataFile.fileSizeInBytes();
                this.positionalDeleteSize += dataFile.fileSizeInBytes();
                this.posDeleteRecordCnt += dataFile.recordCount();
                ++this.posDeleteFileCnt;
                continue;
            }
            this.equalityDeleteSize += dataFile.fileSizeInBytes();
            this.eqDeleteRecordCnt += dataFile.recordCount();
            ++this.eqDeleteFileCnt;
        }
    }

    public MetricsSummary(Collection<MetricsSummary> taskSummaries) {
        taskSummaries.forEach(metrics -> {
            this.newDataFileCnt += metrics.getNewDataFileCnt();
            this.newDataSize += metrics.getNewDataSize();
            this.newDataRecordCnt += metrics.getNewDataRecordCnt();
            this.newDeleteSize += metrics.getNewDeleteSize();
            this.newDeleteFileCnt += metrics.getNewDeleteFileCnt();
            this.newDeleteRecordCnt += metrics.getNewDeleteRecordCnt();
            this.rewriteDataFileCnt += metrics.getRewriteDataFileCnt();
            this.reRowDeletedDataFileCnt += Math.max(metrics.getReRowDeletedDataFileCnt(), metrics.getRewritePosDataFileCnt());
            this.rewritePosDataFileCnt += Math.max(metrics.getReRowDeletedDataFileCnt(), metrics.getRewritePosDataFileCnt());
            this.rewriteDataSize += metrics.getRewriteDataSize();
            this.rewritePosDataSize += metrics.getRewritePosDataSize();
            this.posDeleteFileCnt += metrics.getPosDeleteFileCnt();
            this.positionalDeleteSize += Math.max(metrics.getPositionalDeleteSize(), metrics.getPositionDeleteSize());
            this.positionDeleteSize += Math.max(metrics.getPositionalDeleteSize(), metrics.getPositionDeleteSize());
            this.eqDeleteFileCnt += metrics.getEqDeleteFileCnt();
            this.equalityDeleteSize += metrics.getEqualityDeleteSize();
            this.rewriteDataRecordCnt += metrics.getRewriteDataRecordCnt();
            this.rewritePosDataRecordCnt += metrics.getRewritePosDataRecordCnt();
            this.eqDeleteRecordCnt += metrics.getEqDeleteRecordCnt();
            this.posDeleteRecordCnt += metrics.getPosDeleteRecordCnt();
            this.newFileCnt += metrics.getNewFileCnt();
            this.newFileSize += metrics.getNewFileSize();
        });
    }

    public Map<String, String> summaryAsMap(boolean humanReadable) {
        LinkedHashMap<String, String> summary = new LinkedHashMap<String, String>();
        this.put(summary, INPUT_DATA_FILES, this.rewriteDataFileCnt);
        this.put(summary, INPUT_DATA_SIZE, this.rewriteDataSize, humanReadable);
        this.put(summary, INPUT_DATA_RECORDS, this.rewriteDataRecordCnt);
        this.putIfPositive(summary, INPUT_READ_ONLY_DATA_FILES, Math.max(this.reRowDeletedDataFileCnt, this.rewritePosDataFileCnt));
        this.putIfPositive(summary, INPUT_READ_ONLY_DATA_SIZE, this.rewritePosDataSize, humanReadable);
        this.putIfPositive(summary, INPUT_READ_ONLY_DATA_RECORDS, this.rewritePosDataRecordCnt);
        this.putIfPositive(summary, INPUT_EQ_DELETE_FILES, this.eqDeleteFileCnt);
        this.putIfPositive(summary, INPUT_EQ_DELETE_SIZE, this.equalityDeleteSize, humanReadable);
        this.putIfPositive(summary, INPUT_EQ_DELETE_RECORDS, this.eqDeleteRecordCnt);
        this.putIfPositive(summary, INPUT_POS_DELETE_FILES, this.posDeleteFileCnt);
        this.putIfPositive(summary, INPUT_POS_DELETE_SIZE, Math.max(this.positionalDeleteSize, this.positionDeleteSize), humanReadable);
        this.putIfPositive(summary, INPUT_POS_DELETE_RECORDS, this.posDeleteRecordCnt);
        this.put(summary, OUTPUT_DATA_FILES, this.newDataFileCnt);
        this.put(summary, OUTPUT_DATA_SIZE, this.newDataSize, humanReadable);
        this.put(summary, OUTPUT_DATA_RECORDS, this.newDataRecordCnt);
        this.putIfPositive(summary, OUTPUT_DELETE_FILES, this.newDeleteFileCnt);
        this.putIfPositive(summary, OUTPUT_DELETE_SIZE, this.newDeleteSize, humanReadable);
        this.putIfPositive(summary, OUTPUT_DELETE_RECORDS, this.newDeleteRecordCnt);
        return summary;
    }

    private void putIfPositive(Map<String, String> summary, String key, long value) {
        this.putIfPositive(summary, key, value, false);
    }

    private void putIfPositive(Map<String, String> summary, String key, long value, boolean humanReadable) {
        if (value > 0L) {
            this.put(summary, key, value, humanReadable);
        }
    }

    private void put(Map<String, String> summary, String key, long value) {
        this.put(summary, key, value, false);
    }

    private void put(Map<String, String> summary, String key, long value, boolean humanReadable) {
        summary.put(key, humanReadable ? CommonUtil.byteToXB((long)value) : String.valueOf(value));
    }

    public FilesStatistics getInputFilesStatistics() {
        FilesStatisticsBuilder inputBuilder = new FilesStatisticsBuilder();
        inputBuilder.addFiles(this.equalityDeleteSize, this.eqDeleteFileCnt);
        inputBuilder.addFiles(Math.max(this.positionDeleteSize, this.positionalDeleteSize), this.posDeleteFileCnt);
        inputBuilder.addFiles(this.rewriteDataSize, this.rewriteDataFileCnt);
        inputBuilder.addFiles(this.rewritePosDataSize, Math.max(this.reRowDeletedDataFileCnt, this.rewritePosDataFileCnt));
        return inputBuilder.build();
    }

    public FilesStatistics getOutputFilesStatistics() {
        FilesStatisticsBuilder outputBuilder = new FilesStatisticsBuilder();
        outputBuilder.addFiles(this.newFileSize, this.newFileCnt);
        return outputBuilder.build();
    }

    public long getNewFileSize() {
        return this.newFileSize;
    }

    public int getNewFileCnt() {
        return this.newFileCnt;
    }

    public long getNewDataSize() {
        return this.newDataSize;
    }

    protected void setNewDataSize(long newDataSize) {
        this.newDataSize = newDataSize;
    }

    public int getNewDataFileCnt() {
        return this.newDataFileCnt;
    }

    protected void setNewDataFileCnt(int newDataFileCnt) {
        this.newDataFileCnt = newDataFileCnt;
    }

    public long getNewDataRecordCnt() {
        return this.newDataRecordCnt;
    }

    protected void setNewDataRecordCnt(long newDataRecordCnt) {
        this.newDataRecordCnt = newDataRecordCnt;
    }

    public void setNewDeleteSize(long newDeleteSize) {
        this.newDeleteSize = newDeleteSize;
    }

    public void setNewDeleteFileCnt(int newDeleteFileCnt) {
        this.newDeleteFileCnt = newDeleteFileCnt;
    }

    public long getNewDeleteSize() {
        return this.newDeleteSize;
    }

    public int getNewDeleteFileCnt() {
        return this.newDeleteFileCnt;
    }

    public long getNewDeleteRecordCnt() {
        return this.newDeleteRecordCnt;
    }

    protected void setNewDeleteRecordCnt(long newDeleteRecordCnt) {
        this.newDeleteRecordCnt = newDeleteRecordCnt;
    }

    public void setNewFileSize(long newFileSize) {
        this.newFileSize = newFileSize;
    }

    public void setNewFileCnt(int newFileCnt) {
        this.newFileCnt = newFileCnt;
    }

    public long getRewriteDataSize() {
        return this.rewriteDataSize;
    }

    public long getRewritePosDataSize() {
        return this.rewritePosDataSize;
    }

    public long getEqualityDeleteSize() {
        return this.equalityDeleteSize;
    }

    public long getPositionalDeleteSize() {
        return this.positionalDeleteSize;
    }

    public long getPositionDeleteSize() {
        return this.positionDeleteSize;
    }

    public int getRewriteDataFileCnt() {
        return this.rewriteDataFileCnt;
    }

    public int getReRowDeletedDataFileCnt() {
        return this.reRowDeletedDataFileCnt;
    }

    public int getRewritePosDataFileCnt() {
        return this.rewritePosDataFileCnt;
    }

    public int getEqDeleteFileCnt() {
        return this.eqDeleteFileCnt;
    }

    public int getPosDeleteFileCnt() {
        return this.posDeleteFileCnt;
    }

    public long getRewriteDataRecordCnt() {
        return this.rewriteDataRecordCnt;
    }

    public long getRewritePosDataRecordCnt() {
        return this.rewritePosDataRecordCnt;
    }

    public long getEqDeleteRecordCnt() {
        return this.eqDeleteRecordCnt;
    }

    public long getPosDeleteRecordCnt() {
        return this.posDeleteRecordCnt;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rewriteDataSize", this.rewriteDataSize).add("rewriteDataFileCnt", this.rewriteDataFileCnt).add("rewriteDataRecordCnt", this.rewriteDataRecordCnt).add("rewritePosDataSize", this.rewritePosDataSize).add("rewritePosDataFileCnt", this.rewritePosDataFileCnt).add("reRowDeletedDataFileCnt", this.reRowDeletedDataFileCnt).add("rewritePosDataRecordCnt", this.rewritePosDataRecordCnt).add("equalityDeleteSize", this.equalityDeleteSize).add("eqDeleteFileCnt", this.eqDeleteFileCnt).add("eqDeleteRecordCnt", this.eqDeleteRecordCnt).add("positionDeleteSize", this.positionDeleteSize).add("positionalDeleteSize", this.positionalDeleteSize).add("posDeleteFileCnt", this.posDeleteFileCnt).add("posDeleteRecordCnt", this.posDeleteRecordCnt).add("newFileSize", this.newFileSize).add("newFileCnt", this.newFileCnt).add("newDataSize", this.newDataSize).add("newDataFileCnt", this.newDataFileCnt).add("newDataRecordCnt", this.newDataRecordCnt).add("newDeleteSize", this.newDeleteSize).add("newDeleteFileCnt", this.newDeleteFileCnt).add("newDeleteRecordCnt", this.newDeleteRecordCnt).toString();
    }
}

