/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.parser.defaults;

import com.github.pagehelper.PageException;
import com.github.pagehelper.parser.OrderBySqlParser;
import com.github.pagehelper.parser.SqlParserUtil;
import java.util.List;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class DefaultOrderBySqlParser
implements OrderBySqlParser {
    private static final Log log = LogFactory.getLog(DefaultOrderBySqlParser.class);

    @Override
    public String converToOrderBySql(String sql, String orderBy) {
        Statement stmt = null;
        try {
            stmt = SqlParserUtil.parse(sql);
            Select select = (Select)stmt;
            List<OrderByElement> orderByElements = DefaultOrderBySqlParser.extraOrderBy(select);
            String defaultOrderBy = PlainSelect.orderByToString(orderByElements);
            if (defaultOrderBy.indexOf(63) != -1) {
                throw new PageException("The order by in the original SQL[" + sql + "] contains parameters, so it cannot be modified using the OrderBy plugin!");
            }
            sql = select.toString();
        }
        catch (Throwable e) {
            log.warn("Failed to handle sorting: " + e + ", downgraded to a direct splice of the order by parameter");
        }
        return sql + " order by " + orderBy;
    }

    public static List<OrderByElement> extraOrderBy(Select select) {
        if (select != null) {
            if (select instanceof PlainSelect || select instanceof SetOperationList) {
                List orderByElements = select.getOrderByElements();
                select.setOrderByElements(null);
                return orderByElements;
            }
            if (select instanceof ParenthesedSelect) {
                DefaultOrderBySqlParser.extraOrderBy(((ParenthesedSelect)select).getSelect());
            }
        }
        return null;
    }
}

