/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Scan;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.iceberg.spark.source.SparkPartitioningAwareScan;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.read.Statistics;
import org.apache.spark.sql.connector.read.SupportsRuntimeFiltering;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.In;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SparkCopyOnWriteScan
extends SparkPartitioningAwareScan<FileScanTask>
implements SupportsRuntimeFiltering {
    private static final Logger LOG = LoggerFactory.getLogger(SparkCopyOnWriteScan.class);
    private final Snapshot snapshot;
    private Set<String> filteredLocations = null;

    SparkCopyOnWriteScan(SparkSession spark, Table table, SparkReadConf readConf, Schema expectedSchema, List<Expression> filters) {
        this(spark, table, null, null, readConf, expectedSchema, filters);
    }

    SparkCopyOnWriteScan(SparkSession spark, Table table, BatchScan scan, Snapshot snapshot, SparkReadConf readConf, Schema expectedSchema, List<Expression> filters) {
        super(spark, table, (Scan<?, ? extends ScanTask, ? extends ScanTaskGroup<?>>)scan, readConf, expectedSchema, filters);
        this.snapshot = snapshot;
        if (scan == null) {
            this.filteredLocations = Collections.emptySet();
        }
    }

    Long snapshotId() {
        return this.snapshot != null ? Long.valueOf(this.snapshot.snapshotId()) : null;
    }

    @Override
    protected Class<FileScanTask> taskJavaClass() {
        return FileScanTask.class;
    }

    @Override
    public Statistics estimateStatistics() {
        return this.estimateStatistics(this.snapshot);
    }

    public NamedReference[] filterAttributes() {
        NamedReference file = Expressions.column((String)MetadataColumns.FILE_PATH.name());
        return new NamedReference[]{file};
    }

    public void filter(Filter[] filters) {
        Preconditions.checkState((boolean)Objects.equals(this.snapshotId(), this.currentSnapshotId()), (String)"Runtime file filtering is not possible: the table has been concurrently modified. Row-level operation scan snapshot ID: %s, current table snapshot ID: %s. If multiple threads modify the table, use independent Spark sessions in each thread.", (Object)this.snapshotId(), (Object)this.currentSnapshotId());
        for (Filter filter : filters) {
            if (filter instanceof In && ((In)filter).attribute().equalsIgnoreCase(MetadataColumns.FILE_PATH.name())) {
                In in = (In)filter;
                HashSet fileLocations = Sets.newHashSet();
                for (Object value : in.values()) {
                    fileLocations.add((String)value);
                }
                if (this.filteredLocations != null && fileLocations.size() >= this.filteredLocations.size()) continue;
                this.filteredLocations = fileLocations;
                List filteredTasks = this.tasks().stream().filter(file -> fileLocations.contains(((DataFile)file.file()).path().toString())).collect(Collectors.toList());
                LOG.info("{} of {} task(s) for table {} matched runtime file filter with {} location(s)", new Object[]{filteredTasks.size(), this.tasks().size(), this.table().name(), fileLocations.size()});
                this.resetTasks(filteredTasks);
                continue;
            }
            LOG.warn("Unsupported runtime filter {}", (Object)filter);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparkCopyOnWriteScan that = (SparkCopyOnWriteScan)o;
        return this.table().name().equals(that.table().name()) && this.readSchema().equals((Object)that.readSchema()) && this.filterExpressions().toString().equals(that.filterExpressions().toString()) && Objects.equals(this.snapshotId(), that.snapshotId()) && Objects.equals(this.filteredLocations, that.filteredLocations);
    }

    public int hashCode() {
        return Objects.hash(this.table().name(), this.readSchema(), this.filterExpressions().toString(), this.snapshotId(), this.filteredLocations);
    }

    public String toString() {
        return String.format("IcebergCopyOnWriteScan(table=%s, type=%s, filters=%s, caseSensitive=%s)", this.table(), this.expectedSchema().asStruct(), this.filterExpressions(), this.caseSensitive());
    }

    private Long currentSnapshotId() {
        Snapshot currentSnapshot = SnapshotUtil.latestSnapshot((Table)this.table(), (String)this.branch());
        return currentSnapshot != null ? Long.valueOf(currentSnapshot.snapshotId()) : null;
    }
}

