/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final Map<String, Class> CLASS_MAP = new HashMap<String, Class>();

    public static Object invoke(String className, String methodName) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Class classRef = CLASS_MAP.computeIfAbsent(className, key -> {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        });
        if (Objects.isNull(classRef)) {
            LOG.warn("cannot load class {}, skip execute method {}", (Object)className, (Object)methodName);
            return null;
        }
        Method method = classRef.getDeclaredMethod(methodName, new Class[0]);
        return method.invoke(null, new Object[0]);
    }
}

