/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.util.Optional;
import java.util.function.Function;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.meta.Beta;

@FunctionalInterface
public interface TemplateEngine {
    public static final TemplateEngine NOP = (template, ctx) -> template;

    public String render(String var1, StatementContext var2);

    @Beta
    default public Optional<Function<StatementContext, String>> parse(String template, ConfigRegistry config) {
        return Optional.empty();
    }

    @FunctionalInterface
    @Beta
    public static interface Parsing
    extends TemplateEngine {
        @Override
        default public String render(String template, StatementContext ctx) {
            return this.parse(template, ctx.getConfig()).orElseThrow(() -> new UnableToCreateStatementException("Caching template engine did not prepare")).apply(ctx);
        }

        @Override
        public Optional<Function<StatementContext, String>> parse(String var1, ConfigRegistry var2);
    }
}

