/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.collection.type;

import com.google.common.primitives.Bytes;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.baremaps.collection.type.DataType;

public class ByteListDataType
implements DataType<List<Byte>> {
    @Override
    public int size(List<Byte> values) {
        return 4 + values.size() * 1;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, List<Byte> values) {
        buffer.putInt(position, this.size(values));
        byte[] bytes = Bytes.toArray(values);
        buffer.put(position + 4, bytes, 0, bytes.length);
    }

    @Override
    public List<Byte> read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        byte[] bytes = new byte[Math.max(size - 4, 0)];
        buffer.get(position + 4, bytes);
        return Bytes.asList((byte[])bytes);
    }
}

