/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.WorkflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ExecuteSql(String database, Path file, boolean parallel) implements Task
{
    private static final Logger logger = LoggerFactory.getLogger(ExecuteSql.class);

    @Override
    public void execute(WorkflowContext context) throws Exception {
        logger.info("Executing {}", (Object)this.file);
        String sql = ExecuteSql.removeComments(Files.readString(this.file));
        Stream queries = Arrays.stream(sql.split(";"));
        if (this.parallel) {
            queries = (Stream)queries.parallel();
        }
        queries.forEach(query -> {
            DataSource dataSource = context.getDataSource(this.database);
            try (Connection connection = dataSource.getConnection();){
                connection.createStatement().execute((String)query);
            }
            catch (SQLException e) {
                logger.error("Failed executing {}", query);
                throw new WorkflowException(e);
            }
        });
        logger.info("Finished executing {}", (Object)this.file);
    }

    public static String removeComments(String sql) {
        String result = sql;
        Pattern singleLineCommentPattern = Pattern.compile("--.*", 8);
        Matcher singleLineCommentMatcher = singleLineCommentPattern.matcher(result);
        result = singleLineCommentMatcher.replaceAll("");
        Pattern multiLineCommentPattern = Pattern.compile("/\\*.*?\\*/", 32);
        Matcher multiLineMatcher = multiLineCommentPattern.matcher(result);
        result = multiLineMatcher.replaceAll("");
        return result;
    }
}

