/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AbstractPublisherProcessorSignalsHolder;
import io.servicetalk.concurrent.api.PublisherProcessorSignalsHolder;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.QueueFullException;
import io.servicetalk.utils.internal.PlatformDependent;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

final class PublisherProcessorSignalHolders {
    private PublisherProcessorSignalHolders() {
    }

    static <T> PublisherProcessorSignalsHolder<T> fixedSize(final int maxBuffer) {
        return new AbstractPublisherProcessorSignalsHolder<T, Queue<Object>>(maxBuffer, PublisherProcessorSignalHolders.newMpscQueueForItemSize(maxBuffer)){

            @Override
            void offerPastBufferSize(Object signal, Queue<Object> queue) {
                throw new QueueFullException("processor-holder", maxBuffer);
            }
        };
    }

    static <T> PublisherProcessorSignalsHolder<T> fixedSizeDropTail(int maxBuffer) {
        return new AbstractPublisherProcessorSignalsHolder<T, Queue<Object>>(maxBuffer, PublisherProcessorSignalHolders.newMpscQueueForItemSize(maxBuffer)){

            @Override
            void offerPastBufferSize(Object signal, Queue<Object> queue) {
            }
        };
    }

    static <T> PublisherProcessorSignalsHolder<T> fixedSizeDropHead(int maxBuffer) {
        return new AbstractPublisherProcessorSignalsHolder<T, ConcurrentLinkedQueue<Object>>(maxBuffer, new ConcurrentLinkedQueue()){

            @Override
            void offerPastBufferSize(Object signal, ConcurrentLinkedQueue<Object> queue) {
                queue.poll();
                queue.offer(signal);
            }
        };
    }

    private static Queue<Object> newMpscQueueForItemSize(int maxBuffer) {
        return PlatformDependent.newMpscQueue((int)2, (int)FlowControlUtils.addWithOverflowProtection((int)maxBuffer, (int)1));
    }
}

