/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Processors;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.internal.SubscribableCompletable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.transport.netty.internal.NettyFutureCompletable;
import io.servicetalk.transport.netty.internal.PrivilegedListenableAsyncCloseable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class NettyChannelListenableAsyncCloseable
implements PrivilegedListenableAsyncCloseable {
    private static final AtomicIntegerFieldUpdater<NettyChannelListenableAsyncCloseable> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(NettyChannelListenableAsyncCloseable.class, "state");
    private final Channel channel;
    private volatile int state;
    private final CompletableSource.Processor onClosing;
    private final SubscribableCompletable onCloseNoOffload;
    private final Completable onClose;

    public NettyChannelListenableAsyncCloseable(final Channel channel, io.servicetalk.concurrent.api.Executor offloadingExecutor) {
        this.channel = Objects.requireNonNull(channel);
        this.onClosing = Processors.newCompletableProcessor();
        this.onCloseNoOffload = new SubscribableCompletable(){

            protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                try {
                    subscriber.onSubscribe(Cancellable.IGNORE_CANCEL);
                }
                catch (Throwable cause) {
                    SubscriberUtils.handleExceptionFromOnSubscribe((CompletableSource.Subscriber)subscriber, (Throwable)cause);
                    return;
                }
                NettyFutureCompletable.connectToSubscriber(subscriber, channel.closeFuture());
            }
        };
        this.onClose = this.onCloseNoOffload.publishOn((Executor)offloadingExecutor);
        this.onCloseNoOffload.subscribe((CompletableSource.Subscriber)this.onClosing);
    }

    protected final void notifyOnClosing() {
        this.onClosing.onComplete();
    }

    public final Completable onClosing() {
        return SourceAdapters.fromSource((CompletableSource)this.onClosing);
    }

    public final Completable closeAsync() {
        return this.closeAsync(this.onClose());
    }

    public final Completable closeAsyncGracefully() {
        return this.closeAsyncGracefully(this.onClose());
    }

    @Override
    public final Completable closeAsyncNoOffload() {
        return this.closeAsync(this.onCloseNoOffload());
    }

    @Override
    public final Completable closeAsyncGracefullyNoOffload() {
        return this.closeAsyncGracefully(this.onCloseNoOffload());
    }

    private Completable closeAsync(final Completable source) {
        return new SubscribableCompletable(){

            protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                SourceAdapters.toSource((Completable)source).subscribe(subscriber);
                if (stateUpdater.getAndSet(NettyChannelListenableAsyncCloseable.this, 2) != 2) {
                    NettyChannelListenableAsyncCloseable.this.notifyOnClosing();
                    NettyChannelListenableAsyncCloseable.this.channel.close();
                }
            }
        };
    }

    private Completable closeAsyncGracefully(final Completable source) {
        return new SubscribableCompletable(){

            protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                if (stateUpdater.compareAndSet(NettyChannelListenableAsyncCloseable.this, 0, 1)) {
                    NettyChannelListenableAsyncCloseable.this.notifyOnClosing();
                    try {
                        NettyChannelListenableAsyncCloseable.this.doCloseAsyncGracefully();
                    }
                    catch (Throwable t) {
                        SubscriberUtils.deliverErrorFromSource((CompletableSource.Subscriber)subscriber, (Throwable)t);
                        return;
                    }
                }
                SourceAdapters.toSource((Completable)source).subscribe(subscriber);
            }
        };
    }

    public final Completable onClose() {
        return this.onClose;
    }

    final Completable onCloseNoOffload() {
        return this.onCloseNoOffload;
    }

    protected final Channel channel() {
        return this.channel;
    }

    protected void doCloseAsyncGracefully() {
        this.channel.close();
    }
}

