/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.baremaps.model.VectorLayer;

public class TileJSON {
    @Valid
    private String tilejson;
    @Valid
    private String name;
    @Valid
    private String description;
    @Valid
    private String version;
    @Valid
    private String attribution;
    @Valid
    private String template;
    @Valid
    private String legend;
    @Valid
    private String scheme;
    @Valid
    private List<String> tiles = new ArrayList<String>();
    @Valid
    private List<String> grids = new ArrayList<String>();
    @Valid
    private List<String> data = new ArrayList<String>();
    @Valid
    private Integer minzoom;
    @Valid
    private Integer maxzoom;
    @Valid
    private List<Double> bounds = new ArrayList<Double>();
    @Valid
    private List<BigDecimal> center = new ArrayList<BigDecimal>();
    @Valid
    private List<VectorLayer> vectorLayers = new ArrayList<VectorLayer>();
    @Valid
    private Integer fillzoom;

    public TileJSON tilejson(String tilejson) {
        this.tilejson = tilejson;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="tilejson")
    @NotNull
    @Pattern(regexp="\\d+\\.\\d+\\.\\d+\\w?[\\w\\d]*")
    public @NotNull @Pattern(regexp="\\d+\\.\\d+\\.\\d+\\w?[\\w\\d]*") String getTilejson() {
        return this.tilejson;
    }

    public void setTilejson(String tilejson) {
        this.tilejson = tilejson;
    }

    public TileJSON name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TileJSON description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TileJSON version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="version")
    @Pattern(regexp="\\d+\\.\\d+\\.\\d+\\w?[\\w\\d]*")
    public @Pattern(regexp="\\d+\\.\\d+\\.\\d+\\w?[\\w\\d]*") String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public TileJSON attribution(String attribution) {
        this.attribution = attribution;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="attribution")
    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public TileJSON template(String template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="template")
    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public TileJSON legend(String legend) {
        this.legend = legend;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="legend")
    public String getLegend() {
        return this.legend;
    }

    public void setLegend(String legend) {
        this.legend = legend;
    }

    public TileJSON scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="scheme")
    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public TileJSON tiles(List<String> tiles) {
        this.tiles = tiles;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="tiles")
    @NotNull
    public List<String> getTiles() {
        return this.tiles;
    }

    public void setTiles(List<String> tiles) {
        this.tiles = tiles;
    }

    public TileJSON grids(List<String> grids) {
        this.grids = grids;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="grids")
    public List<String> getGrids() {
        return this.grids;
    }

    public void setGrids(List<String> grids) {
        this.grids = grids;
    }

    public TileJSON data(List<String> data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="data")
    public List<String> getData() {
        return this.data;
    }

    public void setData(List<String> data) {
        this.data = data;
    }

    public TileJSON minzoom(Integer minzoom) {
        this.minzoom = minzoom;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="minzoom")
    @Min(value=0L)
    @Max(value=30L)
    public @Min(value=0L) @Max(value=30L) Integer getMinzoom() {
        return this.minzoom;
    }

    public void setMinzoom(Integer minzoom) {
        this.minzoom = minzoom;
    }

    public TileJSON maxzoom(Integer maxzoom) {
        this.maxzoom = maxzoom;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="maxzoom")
    @Min(value=0L)
    @Max(value=30L)
    public @Min(value=0L) @Max(value=30L) Integer getMaxzoom() {
        return this.maxzoom;
    }

    public void setMaxzoom(Integer maxzoom) {
        this.maxzoom = maxzoom;
    }

    public TileJSON bounds(List<Double> bounds) {
        this.bounds = bounds;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="bounds")
    public List<Double> getBounds() {
        return this.bounds;
    }

    public void setBounds(List<Double> bounds) {
        this.bounds = bounds;
    }

    public TileJSON center(List<BigDecimal> center) {
        this.center = center;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="center")
    public List<BigDecimal> getCenter() {
        return this.center;
    }

    public void setCenter(List<BigDecimal> center) {
        this.center = center;
    }

    public TileJSON vectorLayers(List<VectorLayer> vectorLayers) {
        this.vectorLayers = vectorLayers;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="vector_layers")
    public List<VectorLayer> getVectorLayers() {
        return this.vectorLayers;
    }

    public void setVectorLayers(List<VectorLayer> vectorLayers) {
        this.vectorLayers = vectorLayers;
    }

    public TileJSON fillzoom(Integer fillzoom) {
        this.fillzoom = fillzoom;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="fillzoom")
    public Integer getFillzoom() {
        return this.fillzoom;
    }

    public void setFillzoom(Integer fillzoom) {
        this.fillzoom = fillzoom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TileJSON tileJSON = (TileJSON)o;
        return Objects.equals(this.tilejson, tileJSON.tilejson) && Objects.equals(this.name, tileJSON.name) && Objects.equals(this.description, tileJSON.description) && Objects.equals(this.version, tileJSON.version) && Objects.equals(this.attribution, tileJSON.attribution) && Objects.equals(this.template, tileJSON.template) && Objects.equals(this.legend, tileJSON.legend) && Objects.equals(this.scheme, tileJSON.scheme) && Objects.equals(this.tiles, tileJSON.tiles) && Objects.equals(this.grids, tileJSON.grids) && Objects.equals(this.data, tileJSON.data) && Objects.equals(this.minzoom, tileJSON.minzoom) && Objects.equals(this.maxzoom, tileJSON.maxzoom) && Objects.equals(this.bounds, tileJSON.bounds) && Objects.equals(this.center, tileJSON.center) && Objects.equals(this.vectorLayers, tileJSON.vectorLayers) && Objects.equals(this.fillzoom, tileJSON.fillzoom);
    }

    public int hashCode() {
        return Objects.hash(this.tilejson, this.name, this.description, this.version, this.attribution, this.template, this.legend, this.scheme, this.tiles, this.grids, this.data, this.minzoom, this.maxzoom, this.bounds, this.center, this.vectorLayers, this.fillzoom);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TileJSON {\n");
        sb.append("    tilejson: ").append(this.toIndentedString(this.tilejson)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    attribution: ").append(this.toIndentedString(this.attribution)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    legend: ").append(this.toIndentedString(this.legend)).append("\n");
        sb.append("    scheme: ").append(this.toIndentedString(this.scheme)).append("\n");
        sb.append("    tiles: ").append(this.toIndentedString(this.tiles)).append("\n");
        sb.append("    grids: ").append(this.toIndentedString(this.grids)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    minzoom: ").append(this.toIndentedString(this.minzoom)).append("\n");
        sb.append("    maxzoom: ").append(this.toIndentedString(this.maxzoom)).append("\n");
        sb.append("    bounds: ").append(this.toIndentedString(this.bounds)).append("\n");
        sb.append("    center: ").append(this.toIndentedString(this.center)).append("\n");
        sb.append("    vectorLayers: ").append(this.toIndentedString(this.vectorLayers)).append("\n");
        sb.append("    fillzoom: ").append(this.toIndentedString(this.fillzoom)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

