/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.tiff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mil.nga.tiff.FileDirectory;

public class TIFFImage {
    private final List<FileDirectory> fileDirectories = new ArrayList<FileDirectory>();

    public TIFFImage() {
    }

    public TIFFImage(FileDirectory fileDirectory) {
        this.fileDirectories.add(fileDirectory);
    }

    public TIFFImage(List<FileDirectory> fileDirectories) {
        this.fileDirectories.addAll(fileDirectories);
    }

    public void add(FileDirectory fileDirectory) {
        this.fileDirectories.add(fileDirectory);
    }

    public List<FileDirectory> getFileDirectories() {
        return Collections.unmodifiableList(this.fileDirectories);
    }

    public FileDirectory getFileDirectory() {
        return this.getFileDirectory(0);
    }

    public FileDirectory getFileDirectory(int index) {
        return this.fileDirectories.get(index);
    }

    public long sizeHeaderAndDirectories() {
        long size = 8L;
        for (FileDirectory directory : this.fileDirectories) {
            size += directory.size();
        }
        return size;
    }

    public long sizeHeaderAndDirectoriesWithValues() {
        long size = 8L;
        for (FileDirectory directory : this.fileDirectories) {
            size += directory.sizeWithValues();
        }
        return size;
    }
}

