/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.bulkprocessor.handler;

import de.bytefish.pgbulkinsert.IPgBulkInsert;
import de.bytefish.pgbulkinsert.bulkprocessor.handler.IBulkWriteHandler;
import de.bytefish.pgbulkinsert.util.PostgreSqlUtils;
import java.sql.Connection;
import java.util.List;
import java.util.function.Supplier;
import org.postgresql.PGConnection;

public class BulkWriteHandler<TEntity>
implements IBulkWriteHandler<TEntity> {
    private final IPgBulkInsert<TEntity> client;
    private final Supplier<Connection> connectionFactory;

    public BulkWriteHandler(IPgBulkInsert<TEntity> client, Supplier<Connection> connectionFactory) {
        this.client = client;
        this.connectionFactory = connectionFactory;
    }

    @Override
    public void write(List<TEntity> entities) throws Exception {
        try (Connection connection = this.connectionFactory.get();){
            PGConnection pgConnection = PostgreSqlUtils.getPGConnection(connection);
            this.client.saveAll(pgConnection, entities.stream());
        }
    }
}

