/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.util.centroid;

import java.util.List;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryCollection;
import mil.nga.sf.GeometryType;
import mil.nga.sf.MultiPoint;
import mil.nga.sf.Point;
import mil.nga.sf.util.SFException;

public class CentroidPoint {
    private int count = 0;
    private Point sum = new Point();

    public CentroidPoint() {
    }

    public CentroidPoint(Geometry geometry) {
        this.add(geometry);
    }

    public void add(Geometry geometry) {
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case POINT: {
                this.add((Point)geometry);
                break;
            }
            case MULTIPOINT: {
                MultiPoint multiPoint = (MultiPoint)geometry;
                for (Point point : multiPoint.getPoints()) {
                    this.add(point);
                }
                break;
            }
            case GEOMETRYCOLLECTION: 
            case MULTICURVE: 
            case MULTISURFACE: {
                GeometryCollection geomCollection = (GeometryCollection)geometry;
                List geometries = geomCollection.getGeometries();
                for (Geometry subGeometry : geometries) {
                    this.add(subGeometry);
                }
                break;
            }
            default: {
                throw new SFException("Unsupported " + this.getClass().getSimpleName() + " Geometry Type: " + geometryType);
            }
        }
    }

    private void add(Point point) {
        ++this.count;
        this.sum.setX(this.sum.getX() + point.getX());
        this.sum.setY(this.sum.getY() + point.getY());
    }

    public Point getCentroid() {
        Point centroid = new Point(this.sum.getX() / (double)this.count, this.sum.getY() / (double)this.count);
        return centroid;
    }
}

