/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.impl.JDKAccessorImpl;
import java.util.Objects;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class JDKAccessor {
    private static final boolean previewEnabled;

    private JDKAccessor() {
    }

    public static boolean isVirtualThread(Thread t) {
        Objects.requireNonNull(t);
        return previewEnabled && JDKAccessorImpl.isVirtualThread(t);
    }

    static {
        boolean enabled;
        try {
            JDKAccessorImpl.ensureInitialized();
            enabled = true;
        }
        catch (LinkageError e) {
            enabled = false;
        }
        previewEnabled = enabled;
    }
}

