/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.lineage;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import java.util.Collections;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.internal.Dependencies;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.identification.DefaultResolution;
import org.apache.sis.metadata.iso.maintenance.DefaultScope;
import org.apache.sis.util.iso.Types;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.gmi.LE_Source;
import org.apache.sis.xml.bind.metadata.MD_Resolution;
import org.apache.sis.xml.bind.metadata.MD_Scope;
import org.apache.sis.xml.bind.metadata.RS_ReferenceSystem;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.RepresentativeFraction;
import org.opengis.metadata.identification.Resolution;
import org.opengis.metadata.lineage.NominalResolution;
import org.opengis.metadata.lineage.ProcessStep;
import org.opengis.metadata.lineage.Source;
import org.opengis.metadata.quality.Scope;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

@TitleProperty(name="description")
@XmlType(name="LI_Source_Type", propOrder={"description", "scaleDenominator", "sourceSpatialResolution", "sourceReferenceSystem", "sourceCitation", "sources", "sourceExtents", "scope", "sourceSteps", "processedLevel", "resolution"})
@XmlRootElement(name="LI_Source")
@XmlSeeAlso(value={LE_Source.class})
public class DefaultSource
extends ISOMetadata
implements Source {
    private static final long serialVersionUID = -8444238043227180224L;
    private InternationalString description;
    private Resolution sourceSpatialResolution;
    private ReferenceSystem sourceReferenceSystem;
    private Citation sourceCitation;
    private Collection<Citation> sourceMetadata;
    private Scope scope;
    private Collection<ProcessStep> sourceSteps;
    private Identifier processedLevel;
    private NominalResolution resolution;

    public DefaultSource() {
    }

    public DefaultSource(CharSequence description) {
        this.description = Types.toInternationalString(description);
    }

    public DefaultSource(Source object) {
        super(object);
        if (object != null) {
            this.description = object.getDescription();
            this.sourceReferenceSystem = object.getSourceReferenceSystem();
            this.sourceCitation = object.getSourceCitation();
            this.sourceSteps = this.copyCollection(object.getSourceSteps(), ProcessStep.class);
            this.processedLevel = object.getProcessedLevel();
            this.resolution = object.getResolution();
            if (object instanceof DefaultSource) {
                this.sourceSpatialResolution = ((DefaultSource)object).getSourceSpatialResolution();
                this.sourceMetadata = this.copyCollection(((DefaultSource)object).getSourceMetadata(), Citation.class);
                this.scope = ((DefaultSource)object).getScope();
            } else {
                this.setScaleDenominator(object.getScaleDenominator());
                this.setSourceExtents(object.getSourceExtents());
            }
        }
    }

    public static DefaultSource castOrCopy(Source object) {
        if (object == null || object instanceof DefaultSource) {
            return (DefaultSource)object;
        }
        return new DefaultSource(object);
    }

    @XmlElement(name="description")
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString newValue) {
        this.checkWritePermission(this.description);
        this.description = newValue;
    }

    @XmlElement(name="sourceSpatialResolution")
    @XmlJavaTypeAdapter(value=MD_Resolution.Since2014.class)
    @UML(identifier="sourceSpatialResolution", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Resolution getSourceSpatialResolution() {
        return this.sourceSpatialResolution;
    }

    public void setSourceSpatialResolution(Resolution newValue) {
        this.checkWritePermission(this.sourceSpatialResolution);
        this.sourceSpatialResolution = newValue;
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getSourceSpatialResolution"})
    @XmlElement(name="scaleDenominator", namespace="http://www.isotc211.org/2005/gmd")
    public RepresentativeFraction getScaleDenominator() {
        Resolution resolution;
        if (FilterByVersion.LEGACY_METADATA.accept() && (resolution = this.getSourceSpatialResolution()) != null) {
            return resolution.getEquivalentScale();
        }
        return null;
    }

    @Deprecated(since="1.0")
    public void setScaleDenominator(RepresentativeFraction newValue) {
        this.checkWritePermission(this.sourceSpatialResolution);
        Resolution resolution = null;
        if (newValue != null) {
            resolution = this.sourceSpatialResolution;
            if (resolution instanceof DefaultResolution) {
                ((DefaultResolution)resolution).setEquivalentScale(newValue);
            } else {
                resolution = new DefaultResolution(newValue);
            }
        }
        if (resolution != this.sourceSpatialResolution) {
            this.setSourceSpatialResolution(resolution);
        }
    }

    @XmlElement(name="sourceReferenceSystem")
    @XmlJavaTypeAdapter(value=RS_ReferenceSystem.Since2014.class)
    public ReferenceSystem getSourceReferenceSystem() {
        return this.sourceReferenceSystem;
    }

    public void setSourceReferenceSystem(ReferenceSystem newValue) {
        this.checkWritePermission(this.sourceReferenceSystem);
        this.sourceReferenceSystem = newValue;
    }

    @XmlElement(name="sourceCitation")
    public Citation getSourceCitation() {
        return this.sourceCitation;
    }

    public void setSourceCitation(Citation newValue) {
        this.checkWritePermission(this.sourceCitation);
        this.sourceCitation = newValue;
    }

    @UML(identifier="sourceMetadata", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getSourceMetadata() {
        this.sourceMetadata = this.nonNullCollection(this.sourceMetadata, Citation.class);
        return this.sourceMetadata;
    }

    public void setSourceMetadata(Collection<? extends Citation> newValues) {
        this.sourceMetadata = this.writeCollection(newValues, this.sourceMetadata, Citation.class);
    }

    @XmlElement(name="scope")
    @XmlJavaTypeAdapter(value=MD_Scope.Since2014.class)
    @UML(identifier="scope", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope newValue) {
        this.checkWritePermission(this.scope);
        this.scope = newValue;
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getScope"})
    @XmlElement(name="sourceExtent", namespace="http://www.isotc211.org/2005/gmd")
    public Collection<Extent> getSourceExtents() {
        Scope scope;
        if (FilterByVersion.LEGACY_METADATA.accept() && (scope = this.getScope()) != null) {
            if (!(scope instanceof DefaultScope)) {
                if (super.state() != ModifiableMetadata.State.FINAL) {
                    this.scope = scope = new DefaultScope(scope);
                } else {
                    return Collections.singleton(scope.getExtent());
                }
            }
            return ((DefaultScope)scope).getExtents();
        }
        return null;
    }

    @Deprecated(since="1.0")
    public void setSourceExtents(Collection<? extends Extent> newValues) {
        this.checkWritePermission(this.scope);
        Scope scope = this.scope;
        if (!(scope instanceof DefaultScope)) {
            scope = new DefaultScope(scope);
            this.setScope(scope);
        }
        ((DefaultScope)scope).setExtents(newValues);
    }

    @XmlElement(name="sourceStep")
    public Collection<ProcessStep> getSourceSteps() {
        this.sourceSteps = this.nonNullCollection(this.sourceSteps, ProcessStep.class);
        return this.sourceSteps;
    }

    public void setSourceSteps(Collection<? extends ProcessStep> newValues) {
        this.sourceSteps = this.writeCollection(newValues, this.sourceSteps, ProcessStep.class);
    }

    @XmlElement(name="processedLevel")
    public Identifier getProcessedLevel() {
        return this.processedLevel;
    }

    public void setProcessedLevel(Identifier newValue) {
        this.checkWritePermission(this.processedLevel);
        this.processedLevel = newValue;
    }

    @XmlElement(name="resolution")
    public NominalResolution getResolution() {
        return this.resolution;
    }

    public void setResolution(NominalResolution newValue) {
        this.checkWritePermission(this.resolution);
        this.resolution = newValue;
    }

    @XmlElement(name="sourceMetadata")
    private Collection<Citation> getSources() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getSourceMetadata() : null;
    }
}

